// Klasa TickTock odmierzajca czas rzeczywisty.
 
class TickTock { 

  String state; // przechowuje stan zegara
 
  synchronized void tick(boolean running) { 
    if(!running) { // zatrzymuje zegar 
      state = "ticked";
      notify(); // powiadamia oczekujcy wtek 
      return; 
    } 
 
    System.out.print("Tick "); 

    // czeka p sekundy
    try {
      Thread.sleep(500);
    } catch(InterruptedException exc) {
      System.out.println("Wtek zosta przerwany.");
    }

    state = "ticked"; // zmienia stan zegara na "ticked"

    notify(); // umoliwia wykonanie metody tock() 
    try { 
      while(!state.equals("tocked"))
        wait(); // oczekuje na zakoczenie metody tock()
    } 
    catch(InterruptedException exc) { 
      System.out.println("Wtek zosta przerwany."); 
    } 
  } 
 
  synchronized void tock(boolean running) { 
    if(!running) { // zatrzymuje zegar 
      state = "tocked";
      notify(); // powiadamia oczekujcy wtek 
      return; 
    } 
 
    System.out.println("Tock"); 

    // czeka p sekundy
    try {
      Thread.sleep(500);
    } catch(InterruptedException exc) {
      System.out.println("Wtek zosta przerwany.");
    }

    state = "tocked"; // zmienia stan zegara na "tocked"

    notify(); // umoliwia wykonanie metody tick() 
    try { 
      while(!state.equals("ticked"))
        wait(); // oczekuje na zakoczenie metody tick()
    } 
    catch(InterruptedException exc) { 
      System.out.println("Wtek zosta przerwany."); 
    } 
  } 
}
