package javanut8.ch05.burritos;

// BEGIN BURRITO_DECORATOR
/*
 * Ta klasa jest dekoratorem dla Burrito — reprezentuje opcjonalne
 * dodatki, które można dodać do burrito.
 */

public abstract class BurritoOptionalExtra implements Burrito {
    private final Burrito burrito;
    private final double price;

    // Ten konstruktor jest chroniony, aby chronić przed domyślnym
    // konstruktorem oraz uniemożliwić szkodliwemu kodowi klienta
    // utworzenie egzemplarza klasy bazowej.
    protected BurritoOptionalExtra(Burrito toDecorate, double myPrice) {
        burrito = toDecorate;
        price = myPrice;
    }

    public final double getPrice() {
        return (burrito.getPrice() + price);
    }
}
// END BURRITO_DECORATOR
