package javanut8.ch04.shapes; // Określa pakiet klasy

public final class Circle extends Shape implements Rotate90 {
    // To jest ogólnie przydatna stała, więc niech będzie publiczna
    public static final double PI = 3.14159;

    protected double r;     // Promień jest ukryty, ale widoczny dla podklas

    // Metoda egzekwująca ograniczenie dotyczące promienia
    // To jest szczegół implementacyjny potrzebny podklasom
    protected void checkRadius(double radius) {
        if (radius < 0.0)
            throw new IllegalArgumentException("Promień nie może być ujemny.");
    }

    // Konstruktor niedomyślny
    public Circle(double r) {
        checkRadius(r);
        this.r = r;
    }

    // Publiczne metody dostępu
    public double getRadius() { return r; }
    public void setRadius(double r) {
        checkRadius(r);
        this.r = r;
    }

    // Metody operujące na polu egzemplarza
    public double area() { return PI * r * r; }
    public double circumference() { return 2 * PI * r; }

    @Override
    public void clockwise() {
        // No-op, koła są niezmienne pod względem obrotu
    }

    @Override
    public void antiClockwise() {
        // No-op, koła są niezmienne pod względem obrotu
    }
}