package javanut8.ch02;

import java.util.List;

public class SwitchExpressions {
    public static void main(String[] args) {
        var input = args.length <= 0 ? "O" : args[0];
        Boolean yesOrNo = null;
        switch(input) {
            case "t":
            case "T":
                yesOrNo = true;
                break;
            case "n":
            case "N":
                yesOrNo = false;
                break;
            default:
                throw new IllegalArgumentException("Należy wpisać T lub N);
        }

        yesOrNo = switch(input) {
            case "t" -> true;
            case "T" -> true;
            case "N" -> false;
            case "n" -> false;
            default -> throw new IllegalArgumentException("Należy wpisać T lub N");
        };

        yesOrNo = switch(input) {
            case "t", "T" -> true;
            case "n", "N" -> false;
            default -> throw new IllegalArgumentException("Należy wpisać T lub N");
        };

        yesOrNo = switch(input) {
            case "t", "T" -> { System.out.println("Sure"); yield true; }
            case "n", "N" -> { System.out.println("Nope"); yield false; }
            default -> throw new IllegalArgumentException("Należy wpisać T lub N");
        };

        switch(input) {
            case "t", "T" -> System.out.println("Sure");
            case "n", "N" -> System.out.println("Nope");
            default -> throw new IllegalArgumentException("Należy wpisać T lub N");
        }

        System.out.println(yesOrNo);
    }

    private static List<String> maybe() {
       return List.of("n");
    }
}
