package  javanut8.ch03.shapes;        // określa pakiet, do którego należy klasa

public class Circle {  // Klasa nadal jest publiczna.
  // Ta stała jest ogólnie przydatna, więc pozostawiamy ją na widoku publicznym.
  public static final double PI = 3.14159;

  protected double r;  // Promień jest ukryty, ale pozostaje widoczny dla podklas.

  // metoda zapewniająca ograniczenie możliwych wartości promienia
  // Jest to szczegół implementacyjny, który może być potrzebny w podklasach.
  protected void checkRadius(double radius) {
    if (radius < 0.0)
      throw new IllegalArgumentException("Niedozwolony promień ujemny." );
  }

  // niedomyślny konstruktor
  public Circle(double r) {
    checkRadius(r);
    this. r = r;
  }

  // publiczne metody dostępu do danych
  public double getRadius() { return r; }
  public void setRadius(double r) {
    checkRadius(r);
    this. r = r;
  }

  // metody używające pola egzemplarzowego
  public double area() { return PI * r * r; }
  public double circumference() { return 2 * PI * r; }
}