package org.jpwh.web.dao;

import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import java.io.Serializable;
import java.util.List;

/**
 * Interfejs współdzielony przez wszystkie biznesowe obiekty dostępu do danych.
 * <p>
 * W tym interfejsie są wyizolowane wszystkie podstawowe operacje CRUD (create, read, update, delete).
 * Są one współdzielone pomiędzy wszystkimi implementacjami DAO.
 * Bieżący projekt dotyczy warstwy utrwalania bazującej na zarządzaniu stanami
 * (na przykład nie ma funkcji instrukcji UPDATE), która dostarczałaby 
 * automatycznego sprawdzania „zabrudzenia” obiektów biznesowych w stanie
 * utrwalonym.
 */
public interface GenericDAO<T, ID extends Serializable>
    extends Serializable {

    void joinTransaction();

    T findById(ID id);

    T findById(ID id, LockModeType lockModeType);

    T findReferenceById(ID id);

    List<T> findAll();

    Long getCount();

    T makePersistent(T entity);

    void makeTransient(T entity);

    void checkVersion(T entity, boolean forceUpdate);
}
