package org.jpwh.env;

import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

import java.util.Locale;

/**
 * Uruchamia i zatrzymuje menedżera transakcji/pulę bazy danych przed (po) uruchomieniu zestawu testów.
 * <p>
 * Wszystkie testy w zestawie są uruchamiane za pomocą pojedynczego wywołania {@link TransactionManagerSetup}. Wywołaj
 * statyczną metodę {@link TransactionManagerTest#TM} w testach w celu uzyskania dostępu do 
 * menedżera transakcji JTA i połączeń z bazą danych.
 * </p>
 * <p>
 * <code>Baza danych</code> parametrów testów (podanie obsługiwanego
 * {@link DatabaseProduct}) i <code>connectionURL</code> jest opcjonalne.
 * Ustawienie domyślne to egzemplarz bazy danych w pamięci H2. Jest on tworzony i niszczony
 * automatycznie dla każdego zestawu testów.
 * </p>
 */
public class TransactionManagerTest {

    // Statyczny, pojedynczy menedżer połączenia z bazą danych na zestaw testów
    static public TransactionManagerSetup TM;

    @Parameters({"database", "connectionURL"})
    @BeforeSuite()
    public void beforeSuite(@Optional String database,
                            @Optional String connectionURL) throws Exception {
        TM = new TransactionManagerSetup(
            database != null
                ? DatabaseProduct.valueOf(database.toUpperCase(Locale.US))
                : DatabaseProduct.H2,
            connectionURL
        );
    }

    @AfterSuite(alwaysRun = true)
    public void afterSuite() throws Exception {
        if (TM != null)
            TM.stop();
    }
}

