package org.jpwh.dao;

import javax.persistence.LockModeType;
import java.io.Serializable;
import java.util.List;

/**
 * Interfejs współdzielony przez wszystkie biznesowe obiekty dostępu do danych.
 *
*  Wszystkie podstawowe operacje na danych CRUD (create, read, update, delete — tworzenie, odczyt, aktualizacja, usuwanie) są
 * wyizolowane w ramach tego interfejsu i współdzielone pomiędzy wszystkimi implementacjami DAO.
 * Bieżący projekt dotyczy zorientowanej na zarządzanie stanami warstwy utrwalania
 * (na przykład nie ma funkcji dla instrukcji UPDATE), która zapewniałaby
 * automatycznej, transakcyjnej kontroli stanu „zabrudzenia” w stanie
 * utrwalonym.
 */
public interface GenericDAO<T, ID extends Serializable> {

    T findById(ID id);

    T findById(ID id, LockModeType lockModeType);

    T findReferenceById(ID id);

    List<T> findAll();

    Long getCount();

    T makePersistent(T entity);

    void makeTransient(T entity);

    void checkVersion(T entity, boolean forceUpdate);

}

