package org.jpwh.test.service;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jpwh.Constants;
import org.jpwh.shared.ImprovedH2Dialect;
import org.jpwh.web.dao.GenericDAO;
import org.jpwh.web.jaxrs.CaveatEmptorApplication;
import org.jpwh.web.jsf.CatalogService;
import org.jpwh.web.model.Item;

public class IntegrationTest extends Arquillian {

    @Deployment
    public static WebArchive getArchive() {
        return ShrinkWrap.create(WebArchive.class, "test.war")

            .addPackage(IntegrationTest.class.getPackage())

            .addClass(Constants.class)

            .addPackage(CaveatEmptorApplication.class.getPackage())
            .addPackage(CatalogService.class.getPackage())
            .addPackage(Item.class.getPackage())
            .addPackage(GenericDAO.class.getPackage())
            .addPackage(ImprovedH2Dialect.class.getPackage())

            .addAsResource("META-INF/persistence.xml")
            .addAsResource("META-INF/orm.xml")
            .addAsResource("TestData.sql.txt")

            // ZADBAJ O TO, ABY URUCHOMIĆ TEN KOD Z KATALOGIEM MODULE W ROLI
            // BIEŻĄCEGO KATALOGU ROBOCZEGO. W PRZECIWNYM RAZIE BĘDZIE WYKORZYSTANY NIEWŁAŚCIWY PLIK POM.XML!
            .addAsLibraries(Maven.resolver() // Dlaczego nie ma wywołania Maven.resolveDependencies() z ustawieniami domyślnymi?
                .loadPomFromFile("pom.xml") // A to nie jest wartość domyślna. Dlaczego?
                .importRuntimeDependencies() // To nie jest wartość domyślna. Dlaczego?
                .resolve()  // OK, dlaczego miałbym chcieć, aby NIE zostały rozwiązane?
                .withTransitivity() // Myślicie, że to jest zachowanie domyślne wszędzie indziej?
                .asFile()) // No pewnie. Nie rozumiem, dlaczego sami do tego nie doszliście...

            .addAsWebInfResource(EmptyAsset.INSTANCE, "beans.xml");
    }
}

