package org.jpwh.test.concurrency;

import org.jpwh.env.JPATest;
import org.jpwh.model.concurrency.versionall.Item;
import org.testng.annotations.Test;

import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.transaction.UserTransaction;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

public class VersioningAll extends JPATest {

    @Override
    public void configurePersistenceUnit() throws Exception {
        configurePersistenceUnit("ConcurrencyVersioningAllPU");
    }

    @Test(expectedExceptions = OptimisticLockException.class)
    public void firstCommitWins() throws Throwable {
        UserTransaction tx = TM.getUserTransaction();
        try {
            tx.begin();
            EntityManager em = JPA.createEntityManager();
            Item someItem = new Item();
            someItem.setName("Jakiś przedmiot");
            em.persist(someItem);
            tx.commit();
            em.close();
            final Long ITEM_ID = someItem.getId();

            // Ładujemy przedmiot i zmieniamy jego nazwę
            tx.begin();
            em = JPA.createEntityManager();

            Item item = em.find(Item.class, ITEM_ID);

            item.setName("Nowa nazwa");

            // Współbieżna jednostka pracy robi to samo
            Executors.newSingleThreadExecutor().submit(new Callable<Object>() {
                @Override
                public Object call() throws Exception {
                    UserTransaction tx = TM.getUserTransaction();
                    try {
                        tx.begin();
                        EntityManager em = JPA.createEntityManager();

                        Item item = em.find(Item.class, ITEM_ID);
                        item.setName("Inna nazwa");

                        tx.commit();
                        em.close();
                    } catch (Exception ex) {
                        // To nie powinno się zdarzyć. Ta operacja zatwierdzania powinna zwyciężyć!
                        TM.rollback();
                        throw new RuntimeException("Błąd współbieżnej operacji: " + ex, ex);
                    }
                    return null;
                }
            }).get();

            try {
                tx.commit();
                // Sprawdzenie wersji. Ile wierszy zaktualizowano??
            } catch (Exception ex) {
                throw unwrapCauseOfType(ex, OptimisticLockException.class);
            }
            em.close();
        } finally {
            TM.rollback();
        }
    }

}
