package org.jpwh.test.associations;


import org.jpwh.env.JPATest;
import org.jpwh.model.associations.onetomany.bidirectional.Bid;
import org.jpwh.model.associations.onetomany.bidirectional.Item;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import java.math.BigDecimal;
import java.util.Collection;

import static org.testng.Assert.assertEquals;

public class OneToManyBidirectional extends JPATest {

    @Override
    public void configurePersistenceUnit() throws Exception {
        configurePersistenceUnit("OneToManyBidirectionalPU");
    }

    @Test
    public void storeAndLoadItemBids() throws Exception {
        UserTransaction tx = TM.getUserTransaction();
        try {
            tx.begin();
            EntityManager em = JPA.createEntityManager();

            Item someItem = new Item("Jakiś przedmiot");
            em.persist(someItem);

            Bid someBid = new Bid(new BigDecimal("123.00"), someItem);
            someItem.getBids().add(someBid); // Nie zapomnij!
            em.persist(someBid);

            Bid secondBid = new Bid(new BigDecimal("456.00"), someItem);
            someItem.getBids().add(secondBid);
            em.persist(secondBid);

            tx.commit(); // Sprawdzanie "zabrudzenia", wykonanie SQL
            em.close();

            Long ITEM_ID = someItem.getId();

            tx.begin();
            em = JPA.createEntityManager();

            Item item = em.find(Item.class, ITEM_ID); // Pierwszy SELECT ładuje wiersz ITEM
            assertEquals(item.getBids().size(), 2); // Metoda size() wyzwala drugi SELECT

            tx.commit();
            em.close();

            // Powtórz to samo z jawnym zapytaniem. Nie jest potrzebne mapowanie kolekcji!
            tx.begin();
            em = JPA.createEntityManager();

            Collection<Bid> bids =
                    em.createQuery("select b from Bid b where b.item.id = :itemId")
                    .setParameter("itemId", ITEM_ID)
                    .getResultList();
            assertEquals(bids.size(), 2);

            tx.commit();
            em.close();

        } finally {
            TM.rollback();
        }
    }

}