package fileChooser;

import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import javax.swing.filechooser.FileFilter;

/**
 * Widok plikw wywietlajcy ikon obok wszystkich plikw zaakceptowanych przez filtr
 */
public class FileIconView extends FileView
{
   private FileFilter filter;
   private Icon icon;

   /**
    * Tworzy obiekt FileIconView
    * @param aFilter filtr plikw  wszystkie pliki zaakceptowane przez ten filtr bd miay ikon.
    * @param anIcon  ikona wywietlana obok wszystkich zaakceptowanych plikw
    */
   public FileIconView(FileFilter aFilter, Icon anIcon)
   {
      filter = aFilter;
      icon = anIcon;
   }

   public Icon getIcon(File f)
   {
      if (!f.isDirectory() && filter.accept(f)) return icon;
      else return null;
   }
}
