package unsynch;

/**
 * Obiekt Runnable przelewajcy pienidze z jednego konta bankowego na inne
 * @version 1.30 2004-08-01
 * @author Cay Horstmann
 */
public class TransferRunnable implements Runnable
{
   private Bank bank;
   private int fromAccount;
   private double maxAmount;
   private int DELAY = 10;

   /**
    * Tworzy obiekt Runnable do przelewania rodkw
    * @param b bank, na ktrego kontach wykonywany jest przelew
    * @param from konto, z ktrego maj by przelane pienidze
    * @param max maksymalna suma, jaka moe zosta przelana za kadym razem
    */
   public TransferRunnable(Bank b, int from, double max)
   {
      bank = b;
      fromAccount = from;
      maxAmount = max;
   }

   public void run()
   {
      try
      {
         while (true)
         {
            int toAccount = (int) (bank.size() * Math.random());
            double amount = maxAmount * Math.random();
            bank.transfer(fromAccount, toAccount, amount);
            Thread.sleep((int) (DELAY * Math.random()));
         }
      }
      catch (InterruptedException e)
      {
      }
   }
}
