package logging;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;

import static java.lang.System.Logger.Level.*;


/**
 * A modification of the image viewer program that logs various events. Run as
 * java -Djava.util.logging.config.file=logging.properties logging.LoggingImageViewer
 * @version 1.1 2023-09-26
 * @author Cay Horstmann
 */
public class LoggingImageViewer
{
   
   
   public static void main(String[] args)
   {
      EventQueue.invokeLater(() ->
            {
               var frame = new ImageViewerFrame();
               frame.setTitle("LoggingImageViewer");
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               System.Logger logger = System.getLogger("com.horstmann.corejava");
               logger.log(INFO, "Wyświetlanie ramki");
               frame.setVisible(true);
            });
   }
}

/**
 * Ramka zawierająca obraz
 */
class ImageViewerFrame extends JFrame
{
   private static final int DEFAULT_WIDTH = 300;
   private static final int DEFAULT_HEIGHT = 400;   

   private JLabel label;
   private static System.Logger logger = System.getLogger("com.horstmann.corejava");

   public ImageViewerFrame()
   {
      logger.log(TRACE, "Entering ImageViewerFrame()");      
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // pasek menu
      var menuBar = new JMenuBar();
      setJMenuBar(menuBar);

      var menu = new JMenu("Plik");
      menuBar.add(menu);

      var openItem = new JMenuItem("Otwórz");
      menu.add(openItem);
      openItem.addActionListener(new FileOpenListener());

      var exitItem = new JMenuItem("Zamknij");
      menu.add(exitItem);
      exitItem.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               logger.log(INFO, "Zamykanie.");
               System.exit(0);
            }
         });

      // użycie etykiety do wyświetlania obrazów
      label = new JLabel();
      add(label);
      logger.log(TRACE, "Wyjście z ImageViewerFrame()");
   }

   private class FileOpenListener implements ActionListener
   {
      public void actionPerformed(ActionEvent event)
      {
         logger.log(TRACE, "Wejście do ImageViewerFrame.FileOpenListener.actionPerformed(%s)", 
               event);

         // okno wyboru pliku
         var chooser = new JFileChooser();
         chooser.setCurrentDirectory(new File("."));

         // Akceptowanie wszystkich plików z rozszerzeniem .gif.
         chooser.setFileFilter(new javax.swing.filechooser.FileFilter()
            {
               public boolean accept(File f)
               {
                  return f.getName().toLowerCase().endsWith(".gif") || f.isDirectory();
               }

               public String getDescription()
               {
                  return "Obrazy GIF";
               }
            });

         // Wyświetlenie okna dialogowego wyboru pliku.
         int r = chooser.showOpenDialog(ImageViewerFrame.this);

         // Jeśli plik obrazu zostanie zaakceptowany, ustawia go jako ikonę etykiety.
         if (r == JFileChooser.APPROVE_OPTION)
         {
            String name = chooser.getSelectedFile().getPath();
            logger.log(DEBUG, "Odczyt pliku %s", name);
            label.setIcon(new ImageIcon(name));
         }
         else logger.log(DEBUG, "Anulowano okno otwierania pliku.");
         logger.log(TRACE, "Exiting ImageViewerFrame.FileOpenListener.actionPerformed");
      }
   }
}