/*
 * Decompiled with CFR 0.152.
 */
package bytecodeAnnotations;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class EntryLogger
extends ClassVisitor {
    private String className;

    public EntryLogger(ClassWriter classWriter, String string) {
        super(327680, (ClassVisitor)classWriter);
        this.className = string;
    }

    public MethodVisitor visitMethod(int n, final String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
        return new AdviceAdapter(327680, methodVisitor, n, string, string2){
            private String loggerName;

            public AnnotationVisitor visitAnnotation(final String string2, boolean bl) {
                return new AnnotationVisitor(327680){

                    public void visit(String string, Object object) {
                        if (string2.equals("LbytecodeAnnotations/LogEntry;") && string.equals("logger")) {
                            loggerName = object.toString();
                        }
                    }
                };
            }

            public void onMethodEnter() {
                if (this.loggerName != null) {
                    this.visitLdcInsn(this.loggerName);
                    this.visitMethodInsn(184, "java/util/logging/Logger", "getLogger", "(Ljava/lang/String;)Ljava/util/logging/Logger;", false);
                    this.visitLdcInsn(EntryLogger.this.className);
                    this.visitLdcInsn(string);
                    this.visitMethodInsn(182, "java/util/logging/Logger", "entering", "(Ljava/lang/String;Ljava/lang/String;)V", false);
                    this.loggerName = null;
                }
            }
        };
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.out.println("USAGE: java bytecodeAnnotations.EntryLogger classfile");
            System.exit(1);
        }
        Path path = Path.of(stringArray[0], new String[0]);
        ClassReader classReader = new ClassReader(Files.newInputStream(path, new OpenOption[0]));
        ClassWriter classWriter = new ClassWriter(3);
        EntryLogger entryLogger = new EntryLogger(classWriter, path.toString().replace(".class", "").replaceAll("[/\\\\]", "."));
        classReader.accept((ClassVisitor)entryLogger, 8);
        Files.write(Path.of(stringArray[0], new String[0]), classWriter.toByteArray(), new OpenOption[0]);
    }
}

