/**
 * Niniejszy program demonstruje przekazywanie parametrw w Javie.
 * @version 1.01 2018-04-10
 * @author Cay Horstmann
 */
public class ParamTest
{
   public static void main(String[] args)
   {
      /*
       * Test 1: Metody nie mog modyfikowa parametrw liczbowych.
       */
      System.out.println("Testowanie tripleValue:");
      double percent = 10;
      System.out.println("Przed: percent=" + percent);
      tripleValue(percent);
      System.out.println("Po: percent=" + percent);

      /*
       * Test 2: Metody mog zmienia stan parametrw bdcych obiektami.
       */
      System.out.println("\nTestowanie tripleSalary:");
      var harry = new Employee("Grzegorz", 50000);
      System.out.println("Przed: salary=" + harry.getSalary());
      tripleSalary(harry);
      System.out.println("Po: salary=" + harry.getSalary());

      /*
       * Test 3: Metody nie mog dodawa nowych obiektw do parametrw obiektowych.
       */
      System.out.println("\nTestowanie swap:");
      var a = new Employee("Alicja", 70000);
      var b = new Employee("Grzegorz", 60000);
      System.out.println("Przed: a=" + a.getName());
      System.out.println("Po: b=" + b.getName());
      swap(a, b);
      System.out.println("Po: a=" + a.getName());
      System.out.println("Po: b=" + b.getName());
   }

   public static void tripleValue(double x)      // nie dziaa
   {
      x = 3 * x;
      System.out.println("Koniec metody: x=" + x);
   }

   public static void tripleSalary(Employee x)   // dziaa
   {
      x.raiseSalary(200);
      System.out.println("Koniec metody: salary=" + x.getSalary());
   }

   public static void swap(Employee x, Employee y)
   {
      Employee temp = x;
      x = y;
      y = temp;
      System.out.println("Koniec metody: x=" + x.getName());
      System.out.println("Koniec metody: y=" + y.getName());
   }
}

class Employee   // Uproszczona klasa Employee.
{
   private String name;
   private double salary;

   public Employee(String n, double s)
   {
      name = n;
      salary = s;
   }

   public String getName()
   {
      return name;
   }

   public double getSalary()
   {
      return salary;
   }

   public void raiseSalary(double byPercent)
   {
      double raise = salary * byPercent / 100;
      salary += raise;
   }
}