/**
 * Ten program demonstruje uycie metod statycznych.
 * @version 1.02 2008-04-10
 * @author Cay Horstmann
 */
public class StaticTest
{
   public static void main(String[] args)
   {
      // Wstawienie do tablicy staff trzech obiektw reprezentujcych pracownikw.
      var staff = new Employee[3];

      staff[0] = new Employee("Tomasz", 40000);
      staff[1] = new Employee("Dariusz", 60000);
      staff[2] = new Employee("Grzegorz", 65000);

      // Drukowanie informacji o wszystkich obiektach klasy Employee.
      for (Employee e : staff)
      {
         e.setId();
         System.out.println("name=" + e.getName() + ",id=" + e.getId() + ",salary="
               + e.getSalary());
      }

      int n = Employee.getNextId();   // Wywoanie metody statycznej.
      System.out.println("Nastpny dostpny identyfikator=" + n);
   }
}

class Employee
{
   private static int nextId = 1;

   private String name;
   private double salary;
   private int id;

   public Employee(String n, double s)
   {
      name = n;
      salary = s;
      id = advanceId();
   }

   public String getName()
   {
      return name;
   }

   public double getSalary()
   {
      return salary;
   }

   public int getId()
   {
      return id;
   }

    public static int advanceId()
    {
        int r = nextId; // pobiera nastpny dostpny identyfikator
        nextId++;
        return r;
    }

    public static void main(String[] args) // test jednostkowy
    {
        var e = new Employee("Harry", 50000);
        System.out.println(e.getName() + " " + e.getSalary());
    }
}