package optionDialog;

import javax.swing.*;

/**
 * Panel z przecznikami w ramce z tytuem
 */
public class ButtonPanel extends JPanel
{
   private ButtonGroup group;

   /**
    * Tworzy panel przyciskw
    * @param title Tytu wywietlany w obramowaniu
    * @param options Tablica etykiet przecznikw
    */
   public ButtonPanel(String title, String... options)
   {
      setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
      setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
      group = new ButtonGroup();

      // Utworzenie po jednym przeczniku dla kadej opcji
      for (String option : options)
      {
         JRadioButton b = new JRadioButton(option);
         b.setActionCommand(option);
         add(b);
         group.add(b);
         b.setSelected(option == options[0]);
      }
   }

   /**
    * Pobiera aktualnie wybran opcj
    * @return Zwraca etykiet aktualnie wybranego przecznika
    */
   public String getSelection()
   {
      return group.getSelection().getActionCommand();
   }
}

