/**
   @version 1.22 2021-06-17
   @author Cay Horstmann
*/
#include <bitset>
#include <iostream>
#include <ctime>

using namespace std;

int main()
{
    const int N = 2000000;
    clock_t cstart = clock();
    bitset<N + 1> b;
    int i;
    for (i = 2; i <= N; i++)
        b.set(i);
    i = 2;
    while (i * i <= N)
    {
    if (b.test(i))
    {
        int k = i * i;
        while (k <= N)
        {
            b.reset(k);
            k += i;
        }
    }
    i++;
}

clock_t cend = clock();
double millis = 1000.0 * (cend - cstart) / CLOCKS_PER_SEC;

cout << b.count() << " liczb pierwszych\n" << millis << " milisekund\n";

return 0;
}