package radioButton;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Ramka z przykadow etykiet tekstow i przecznikami sucymi do wyboru rozmiaru czcionki.
 */
public class RadioButtonFrame extends JFrame
{
   private JPanel buttonPanel;
   private ButtonGroup group;
   private JLabel label;
   private static final int DEFAULT_SIZE = 36;

   public RadioButtonFrame()
   {      
      // Dodanie przykadowej etykiety tekstowej.

      label = new JLabel("Ko i w grali w koci z pikn m u rda.");
      label.setFont(new Font("Serif", Font.PLAIN, DEFAULT_SIZE));
      add(label, BorderLayout.CENTER);

      // Dodanie przecznikw.

      buttonPanel = new JPanel();
      group = new ButtonGroup();

      addRadioButton("Maa", 8);
      addRadioButton("rednia", 12);
      addRadioButton("Dua", 18);
      addRadioButton("Bardzo dua", 36);

      add(buttonPanel, BorderLayout.SOUTH);
      pack();
   }

   /**
    * Tworzy przecznik ustawiajcy rozmiar czcionki przykadowego tekstu.
    * @param name acuch identyfikujcy przecznik
    * @param size rozmiar czcionki ustawiany przez ten przecznik
    */
   public void addRadioButton(String name, int size)
   {
      boolean selected = size == DEFAULT_SIZE;
      JRadioButton button = new JRadioButton(name, selected);
      group.add(button);
      buttonPanel.add(button);

      // // Ten nasuchiwacz ustawia rozmiar czcionki etykiety

      ActionListener listener = event -> label.setFont(new Font("Serif", Font.PLAIN, size));

      button.addActionListener(listener);
   }
}