package staticInnerClass;

/**
 * Ten program demonstruje zastosowanie statycznych klas wewntrznych.
 * @version 1.02 2015-05-12
 * @author Cay Horstmann
 */
public class StaticInnerClassTest
{
   public static void main(String[] args)
   {
      var values = new double[20];
      for (int i = 0; i < values.length; i++)
         values[i] = 100 * Math.random();
      ArrayAlg.Pair p = ArrayAlg.minmax(values);
      System.out.println("min = " + p.getFirst());
      System.out.println("max = " + p.getSecond());
   }
}

class ArrayAlg
{
   /**
    * Para liczb zmiennoprzecinkowych.
    */
   public static class Pair
   {
      private double first;
      private double second;

      /**
       * Tworzy par dwch liczb zmiennoprzecinkowych.
       * @param f pierwsza liczba
       * @param s druga liczba
       */
      public Pair(double f, double s)
      {
         first = f;
         second = s;
      }

      /**
       * Zwraca pierwsz liczb z pary.
       * @return pierwsza liczba
       */
      public double getFirst()
      {
         return first;
      }

      /**
       * Zwraca drug liczb z pary.
       * @return druga liczba
       */
      public double getSecond()
      {
         return second;
      }
   }

   /**
    * Znajduje najwiksz i najmniejsz warto w tablicy.
    * @param values tablica liczb zmiennoprzecinkowych
    * @return para liczb, w ktrej pierwsza liczba okrela warto najmniejsz, a druga
    * najwiksz
    */
   public static Pair minmax(double[] values)
   {
      double min = Double.POSITIVE_INFINITY;
      double max = Double.NEGATIVE_INFINITY;
      for (double v : values)
      {
         if (min > v) min = v;
         if (max < v) max = v;
      }
      return new Pair(min, max);
   }
}
