package dataExchange;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
 * Elementy suce do podania hasa, ktre wida w oknie dialogowym
 */
public class PasswordChooser extends JPanel
{
   private JTextField username;
   private JPasswordField password;
   private JButton okButton;
   private boolean ok;
   private JDialog dialog;

   public PasswordChooser()
   {
      setLayout(new BorderLayout());

      // Utworzenie panelu z polami nazwy uytkownika i hasa

      var panel = new JPanel();
      panel.setLayout(new GridLayout(2, 2));
      panel.add(new JLabel("Nazwa uytkownika:"));
      panel.add(username = new JTextField(""));
      panel.add(new JLabel("Haso:"));
      panel.add(password = new JPasswordField(""));
      add(panel, BorderLayout.CENTER);

      
      okButton = new JButton("Ok");
      okButton.addActionListener(event -> {
         ok = true;
         dialog.setVisible(false);
      });

      var cancelButton = new JButton("Anuluj");
      cancelButton.addActionListener(event -> dialog.setVisible(false));

      // Dodawanie przyciskw w pobliu poudniowej krawdzi

      var buttonPanel = new JPanel();
      buttonPanel.add(okButton);
      buttonPanel.add(cancelButton);
      add(buttonPanel, BorderLayout.SOUTH);
   }

   /**
    * Ustawia wartoci domylne okna dialogowego
    * @param u domylne informacje uytkownika
    */
   public void setUser(User u)
   {
      username.setText(u.getName());
   }

   /**
    * Pobiera dane podane w oknie dialogowym
    * @return a obiekt typu User, ktrego stan reprezentuje dane wprowadzone w oknie dialogowym
    */

   public User getUser()
   {
      return new User(username.getText(), password.getPassword());
   }

   /**
    * Wywietla panel z elementami przyjmujcymi dane od uytkownika w oknie dialogowym
    * @param parent komponent w ramce nadrzdnej lub warto null
    * @param title tytu okna dialogowego
    */

   public boolean showDialog(Component parent, String title)
   {
      ok = false;

      // Lokalizacja ramki nadrzdnej

      Frame owner = null;
      if (parent instanceof Frame)
         owner = (Frame) parent;
      else
         owner = (Frame) SwingUtilities.getAncestorOfClass(Frame.class, parent);

      // Jeli jest to pierwszy raz lub zmieni si uytkownik, utworzenie nowego okna dialogowego

      if (dialog == null || dialog.getOwner() != owner)
      {
         dialog = new JDialog(owner, true);
         dialog.add(this);
         dialog.getRootPane().setDefaultButton(okButton);
         dialog.pack();
      }

      // Ustawienie tytuu i wywietlenie okna dialogowego

      dialog.setTitle(title);
      dialog.setVisible(true);
      return ok;
   }
}