package preferences;

import java.awt.*;
import java.io.*;
import java.util.prefs.*;

import javax.swing.*;
import javax.swing.filechooser.*;

/**
 * rogram testujcy ustawianie preferencji. Zapamituje pooenie, rozmiar i tytu ramki.
 * position, size, and title.
 * @version 1.03 2015-06-12
 * @author Cay Horstmann
 */
public class PreferencesTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(() -> {
         PreferencesFrame frame = new PreferencesFrame();
         frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
         frame.setVisible(true);
      });
   }
}

/**
 * Ramka pobierajca dane dotyczce pooenia i rozmiaru z preferencji uytkownika oraz aktualizujca  
 * preferencje w momencie zamykania programu
 */
class PreferencesFrame extends JFrame
{
   private static final int DEFAULT_WIDTH = 300;
   private static final int DEFAULT_HEIGHT = 200;
   private Preferences root = Preferences.userRoot();
   private Preferences node = root.node("/com/horstmann/corejava");

   public PreferencesFrame()
   {
      // Sprawdzanie pooenia, rozmiaru i tytuu w preferencjach

      int left = node.getInt("left", 0);
      int top = node.getInt("top", 0);
      int width = node.getInt("width", DEFAULT_WIDTH);
      int height = node.getInt("height", DEFAULT_HEIGHT);
      setBounds(left, top, width, height);

      // Jeli nie ma tytuu, uytkownik zostanie poproszony o jego podanie

      String title = node.get("title", "");
      if (title.equals(""))
         title = JOptionPane.showInputDialog("Please supply a frame title:");
      if (title == null) title = "";
      setTitle(title);

      // Utworzenie okna wyboru plikw wywietlajcego pliki XML

      final JFileChooser chooser = new JFileChooser();
      chooser.setCurrentDirectory(new File("."));
      chooser.setFileFilter(new FileNameExtensionFilter("Pliki XML", "xml"));

      // utworzenie menu

      JMenuBar menuBar = new JMenuBar();
      setJMenuBar(menuBar);
      JMenu menu = new JMenu("Plik");
      menuBar.add(menu);

      JMenuItem exportItem = new JMenuItem("Eksportuj preferencje");
      menu.add(exportItem);
      exportItem
            .addActionListener(event -> {
               if (chooser.showSaveDialog(PreferencesFrame.this) == JFileChooser.APPROVE_OPTION)
               {
                  try
                  {
                     savePreferences();
                     OutputStream out = new FileOutputStream(chooser
                           .getSelectedFile());
                     node.exportSubtree(out);
                     out.close();
                  }
                  catch (Exception e)
                  {
                     e.printStackTrace();
                  }
               }
            });

      JMenuItem importItem = new JMenuItem("Importuj preferencje");
      menu.add(importItem);
      importItem
            .addActionListener(event -> {
               if (chooser.showOpenDialog(PreferencesFrame.this) == JFileChooser.APPROVE_OPTION)
               {
                  try
                  {
                     InputStream in = new FileInputStream(chooser
                           .getSelectedFile());
                     Preferences.importPreferences(in);
                     in.close();
                  }
                  catch (Exception e)
                  {
                     e.printStackTrace();
                  }
               }
            });

      JMenuItem exitItem = new JMenuItem("Zamknij");
      menu.add(exitItem);
      exitItem.addActionListener(event -> {
         savePreferences();
         System.exit(0);
      });
   }
   
   public void savePreferences() 
   {
      node.putInt("left", getX());
      node.putInt("top", getY());
      node.putInt("width", getWidth());
      node.putInt("height", getHeight());
      node.put("title", getTitle());      
   }
}
