// Stosowanie metod instancyjnych w rekordach.

// Ta wersja rekordu Employee definiuje metodę o nazwie lastName(),
// która zwraca fragment łańcucha z komponentu name zawierający 
// nazwisko pracownika. 
// Używa ona także uproszczonego konstruktora, który sprawdza, czy 
// łańcuch name został zapisany w formacie: nazwisko, imię
record Employee(String name, int idNum) {

  // Zastosowanie skróconego konstruktora kanonicznego do usuwania odstępów
  // z początku i końca komponentu name. Konstruktor wykonuje także 
  // prostą walidację, upewniając się, czy łańcuch przekazany w parametrze 
  // name jest zapisany w formacie: nazwisko, imię
  public Employee {
    // Usuwamy znaki odstępu z początku i końca łańcucha
    name = name.trim();

    // Dalszy kod konstruktora wykonuje proste testy, by upewnić się, 
    // że przekazany łańcuch został zapisany w formacie: nazwisko, imię
    //
    // W pierwszej kolejności sprawdzamy, czy łańcuch zawiera tylko jeden przecinek
    int i = name.indexOf(','); // szukamy przecinka po nazwisku
    int j = name.lastIndexOf(',');
    if(i != j) throw
      new IllegalArgumentException("Znaleziono więcej niż jeden przecinek");

    // Następnie sprawdzamy, czy zarówno przed, jak i za przecinkiem zapisano
    // przynajmniej jeden znak inny od spacji 
    if(i < 1 | name.length() == i+1) throw 
      new IllegalArgumentException("Wymagany format to: nazwisko, imię");
  }

  // Metoda instancyjna, która zwraca jedynie nazwisko, bez imienia
  String lastName() {
    return name.substring(0, name.trim().indexOf(','));
  }
}

class RecordDemo4 { 
  public static void main(String[] args) { 
    Employee emp = new Employee("Wilk, Ewa", 1048);

    // Wyświetlamy pełną postać komponentu name
    System.out.println("Pełne nazwisko i imię pracownika: " + emp.name());

    // Wyświetlamy tylko nazwisko
    System.out.println("Tylko nazwisko pracownika: " +  emp.lastName()); 
  }
}
