// Użycie klauzul case ze strzałką i blokiem kodu
class BlockArrowCase { 
 
  public static void main(String[] args) { 
    boolean stopNow;

    int eventCode = 9300;

    // Zastosowanie klauzul case ze strzałką i blokami kodu.
    // Także w tym przypadku zwróć uwagę na brak instrukcji
    // break (ich użycie jest niedozwolone), których nie 
    // trzeba stosować, by zapobiegać przekazywaniu sterowania.
    // Ponieważ elementem docelowym klauzuli jest blok kodu,
    // konieczne jest zwrócenie wartości przy użyciu instrukcji yield.
    int priorityLevel = switch(eventCode) {
      case 1000, 1205, 8900 -> { // Strzałki i bloki kodu
             stopNow = false;
             System.out.println("Alarm");
             yield 1;
           }
      case 2000, 6010, 9128 -> {
             stopNow = false;
             System.out.println("Ostrzeżenie");
             yield 2;
           }
      case 1002, 7023, 9300 -> {
             stopNow = true;
             System.out.println("Niebezpieczeństwo");
             yield 3;
           }
      default ->  { 
             stopNow = false; 
             System.out.println("Normalny");
             yield 0;
          }
    };

    System.out.println("Priorytet zdarzenia o kodzie " + eventCode +
                       " wynosi: " + priorityLevel);
    if(stopNow) System.out.println("Konieczne zatrzymanie.");
  }
}
