// Zastosowanie skróconego konstruktora rekordu

// Deklaracja typu Employee
record Employee(String name, int idNum) {

  // Używamy skróconego konstruktora kanonicznego, aby usunąć
  // znaki odstępu z początku i końca łańcucha zapisywanego 
  // w polu name
  public Employee {
    // Usuwamy znaki odstępu z początku i końca łańcucha    
    name = name.trim();
    System.out.println(name);
  }
}

class RecordDemo2 { 
  public static void main(String[] args) { 
    Employee[] empList = new Employee[4];

    // W tym przypadku imię i nazwisko pracownika nie zawiera żadnych odstępów
    empList[0] = new Employee("Nowak, Jan", 1047);

    // W kolejnych trzech rekordach są odstępy, które zostaną usunięte
    empList[1] = new Employee("  Wilk, Ewa", 1048);
    empList[2] = new Employee("Puchacz, Roman   ", 1049);
    empList[3] = new Employee("  Kowalski, Daniel   ", 1050);

    // Używamy metod dostępowych, by wyświetlić dane pracowników.
    // Zwróć uwagę, że wszystkie znaki odstępu zostały usunięte
    // przez konstruktor
    for(Employee e: empList) 
      System.out.println("Pracownik " + e.name() + " ma identyfikator " + e.idNum());
  }
}
