// Zastosowanie konstruktora niekanonicznego

// Deklaracja rekordu pracownika, Employee, który jawnie deklaruje
// dwa konstruktory: kanoniczny i niekanoniczny
record Employee(String name, int idNum) {

  // Pole statyczne w rekordzie
  static int pendingID = -1;

  // Uproszczony konstruktor kanoniczny, który usuwa znaki odstępu
  // z początku i końca łańcucha zapisywanego w polu name
  public Employee {
    // Usuwamy znaki odstępu z początku i końca łańcucha
    name = name.trim();
  }

  // To jest konstruktor niekanoniczny. Zwróć uwagę, że nie jest 
  // do niego przekazywany identyfikator pracownika. Zamiast niego
  // konstruktor ten przekazuje do konstruktora kanonicznego 
  // wartość statycznego pola pendingID
  public Employee(String name) {
    this(name, pendingID); 
  }
}

class RecordDemo3 { 
  public static void main(String[] args) { 
    Employee[] empList = new Employee[4];

    // Tworzymy listę pracowników - rekordów Employee
    empList[0] = new Employee("Nowak, Jan", 1047);
    empList[1] = new Employee("Wilk, Ewa", 1048);
    empList[2] = new Employee("Puchacz, Roman", 1049);

    // W tym przypadku identyfikator pracownika nie jest dostępny
    empList[3] = new Employee("Kowalski, Daniel");

    // Wyświetlamy dane wszystkich pracowników
    for(Employee e: empList) {
      System.out.print("Pracownik " + e.name());
      if(e.idNum() == Employee.pendingID) System.out.println(" - identyfikator niedostępny");
      else System.out.println(" ma identyfikator " + e.idNum());
    }
  }
}
