// Przykład użycia klasy JList.
import javax.swing.*;  
import javax.swing.event.*; 
import java.awt.*; 
import java.awt.event.*; 
   
public class JListDemo { 

  // tworzy tablicę z nazwami miast
  String Cities[] = { "Nowy Jork", "Chicago", "Houston",
                      "Denver", "Los Angeles", "Seattle",
                      "Londyn", "Paryż", "Nowe Delhi",
                      "Hongkong", "Tokio", "Sydney" };
 
  public JListDemo() { 
 
    // przygotowuje okno JFrame
    JFrame jfrm = new JFrame("JListDemo");
    jfrm.setLayout(new FlowLayout());
    jfrm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    jfrm.setSize(200, 200); 
 
    // tworzy komponent JList.
    JList<String> jlst = new JList<String>(Cities); 
 
    // ustawia w komponencie trym jednokrotnego wyboru
    jlst.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 
 
    // dodaje listę do panelu z paskami przewijania
    JScrollPane jscrlp = new JScrollPane(jlst); 
 
    // ustawia preferewane wymiary panelu
    jscrlp.setPreferredSize(new Dimension(120, 90)); 
 
    // tworzy etykietę wyświetlającą nazwę wybranego miasta
    JLabel jlab = new JLabel("Wybierz miasto"); 
 
    // dodaje obiekt nasłuchujący zdarzeń wyboru opcji na liście
    jlst.addListSelectionListener(new ListSelectionListener() {  
      public void valueChanged(ListSelectionEvent le) {  
        // pobiera indeks wybranego elementu listy
        int idx = jlst.getSelectedIndex(); 
 
        // wyświetla wybrany element (jeśli został zaznaczony)
        if(idx != -1) 
          jlab.setText("Bieżący wybór: " + Cities[idx]); 
        else // w przeciwnym razie poprosi o wskazanie miasta
          jlab.setText("Wybierz miasto"); 
      }  
    });  
 
    // dodaje listę i etykietę do panelu treści
    jfrm.add(jscrlp); 
    jfrm.add(jlab); 

    // wyświetla okno
    jfrm.setVisible(true);
  } 

  public static void main(String[] args) { 

    // tworzy okno w wątku obsługi zdarzeń
    SwingUtilities.invokeLater( 
      new Runnable() { 
        public void run() { 
          new JListDemo(); 
        } 
      } 
    ); 
  }
}
