// Rozszerzenie klasy BoxWeight o koszt wysyłki.

// Zaczynamy od klasy Box.
class Box {
  private double width;
  private double height;
  private double depth;

  // tworzenie klonu obiektu
  Box(Box ob) { // konstruktor otrzymuje obiekt
    width = ob.width;
    height = ob.height;
    depth = ob.depth;
  }

  // konstruktor używany, gdy podano wszystkie wymiary
  Box(double w, double h, double d) {
    width = w;
    height = h;
    depth = d;
  }

  // konstruktor używany przy braku wymiarów
  Box() {
    width = -1;  // wartość -1
    height = -1; // wskazuje
    depth = -1;  // niezainicjalizowane pudełko
  }

  // konstruktor używany do tworzenia sześcianów
  Box(double len) {
    width = height = depth = len;
  }

  // oblicz i zwróć objętość
  double volume() {
    return width * height * depth;
  }
}

// dodanie ciężaru
class BoxWeight extends Box {
  double weight; // ciężar pudełka

  // tworzenie klonu obiektu
  BoxWeight(BoxWeight ob) { // konstruktor otrzymuje obiekt
    super(ob);
    weight = ob.weight;
  }

  // konstruktor używany, gdy podano wszystkie wymiary
  BoxWeight(double w, double h, double d, double m) {
    super(w, h, d); // wywołanie konstruktora klasy bazowej
    weight = m;
  }

  // konstruktor domyślny
  BoxWeight() {
    super();
    weight = -1;
  }
  // konstruktor używany do tworzenia sześcianów
  BoxWeight(double len, double m) {
    super(len);
    weight = m;
  }
}

// dodanie kosztów przesyłki
class Shipment extends BoxWeight {
  double cost;

  // tworzenie klonu obiektu
  Shipment(Shipment ob) { // konstruktor otrzymuje obiekt
    super(ob);
    cost = ob.cost;
  }

  // konstruktor używany, gdy podano wszystkie wymiary
  Shipment(double w, double h, double d,
            double m, double c) {
    super(w, h, d, m); // wywołanie konstruktora klasy bazowej
    cost = c;
  }

  // konstruktor domyślny
  Shipment() {
    super();
    cost = -1;
  }

  // konstruktor używany do tworzenia sześcianów
  Shipment(double len, double m, double c) {
    super(len, m);
    cost = c;
  }
}

class DemoShipment {
  public static void main(String args[]) {
    Shipment shipment1 =
               new Shipment(10, 20, 15, 10, 3.41);
    Shipment shipment2 =
               new Shipment(2, 3, 4, 0.76, 1.28);

    double vol;

    vol = shipment1.volume();
    System.out.println("Objętość shipment1: " + vol);
    System.out.println("Ciężar shipment1: "
                        + shipment1.weight);
    System.out.println("Koszt przesyłki w złotówkach: " + shipment1.cost);
    System.out.println();

    vol = shipment2.volume();
    System.out.println("Objętość shipment2: " + vol);
    System.out.println("Ciężar shipment2: "
                        + shipment2.weight);
    System.out.println("Koszt przesyłki w złotówkach: " + shipment2.cost);
  }
}
