// Jeden obiekt Box może posłużyć do inicjalizacji innego obiektu Box.

class Box {
  double width;
  double height;
  double depth;

  // tworzenie klonu obiektu
  Box(Box ob) { // przekazanie obiektu do konstruktora
    width = ob.width;
    height = ob.height;
    depth = ob.depth;
  }

  // konstruktor używany, gdy podano wszystkie wymiary
  Box(double w, double h, double d) {
    width = w;
    height = h;
    depth = d;
  }

  // konstruktor używany przy braku wymiarów
  Box() {
    width = -1;  // wartość -1
    height = -1; // wskazuje 
    depth = -1;  // niezainicjalizowane pudełko
  }

  // konstruktor używany do tworzenia sześcianów
  Box(double len) {
    width = height = depth = len;
  }

  // oblicz i zwróć objętość
  double volume() {
    return width * height * depth;
  }
}
  
class OverloadCons2 {
  public static void main(String args[]) {
    // tworzenie pudełek za pomocą różnych konstruktorów
    Box mybox1 = new Box(10, 20, 15);
    Box mybox2 = new Box();
    Box mycube = new Box(7);

    Box myclone = new Box(mybox1); // tworzenie kopii obiektu mybox1

    double vol;
    // pobranie objętości pierwszego pudełka
    vol = mybox1.volume();
    System.out.println("Objętość mybox1 wynosi " + vol);

    // pobranie objętości drugiego pudełka
    vol = mybox2.volume();
    System.out.println("Objętość mybox2 wynosi " + vol);

    // pobranie objętości sześcianu
    vol = mycube.volume();
    System.out.println("Objętość mycube wynosi " + vol);

    // pobranie objętości klonu
    vol = myclone.volume();
    System.out.println("Objętość clone wynosi " + vol);
  }
}
