// Prezentacja menu platformy JavaFX.
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*;  
import javafx.geometry.*;  
import javafx.scene.input.*; 
import javafx.scene.image.*; 
import javafx.beans.value.*; 
  
public class MenuDemoFinal extends Application {  
  
  MenuBar mb; 
  EventHandler<ActionEvent> MEHandler; 
  ContextMenu editMenu; 
  ToolBar tbDebug; 
 
  Label response;  
 
  public static void main(String[] args) {  
  
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);    
  }  
  
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) {  
  
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja menu - wersja końcowa");  
  
    // Tworzy panel BorderPane, który zostanie użyty jako węzeł korzenia.       
    BorderPane rootNode = new BorderPane();  
  
     // Tworzy obiekt sceny.
    Scene myScene = new Scene(rootNode, 300, 300);  
  
    // Zapisuje obiekt sceny w obszarze roboczym.
    myStage.setScene(myScene);  
  
    // Tworzy etykietę, w której będą wyświetlane wybierane opcje menu.
    response = new Label("Prezentacja menu.");  

    // Obsługa zdarzeń ActionEvent generowanych podczas wybierania
    // opcji menu. 
    MEHandler = new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) {  
        String name = ((MenuItem)ae.getTarget()).getText(); 
 
        // W przypadku wybrania opcji Zakończ należy zakończyć 
        // działanie programu. 
        if(name.equals("Zakończ")) Platform.exit(); 
 
        response.setText( "Wybrano " + name); 
      }  
    };

    // Tworzy pasek menu. 
    mb = new MenuBar(); 
 
    // Tworzy menu Plik 
    makeFileMenu(); 
 
    // Tworzy menu Opcje
    makeOptionsMenu(); 
 
    // Tworzy menu Pomoc
    makeHelpMenu(); 
 
    // Tworzy menu podręczne
    makeContextMenu(); 

    // Tworzy pole tekstowe i określa jego szerokość na 20 kolumn.
    TextField tf = new TextField();
    tf.setPrefColumnCount(20);

    // Dodaje menu podręczne do pola tekstowego.
    tf.setContextMenu(editMenu);

    // Tworzy pasek narzędzi
    makeToolBar();

    // Dodaje menu kontekstowe do całego grafu sceny. 
    rootNode.setOnContextMenuRequested( 
                new EventHandler<ContextMenuEvent>() {   
      public void handle(ContextMenuEvent ae) {  
        // Wyświetla menu w miejscu kliknięcia. 
        editMenu.show(rootNode, ae.getScreenX(), ae.getScreenY()); 
      }  
    });

    // Dodaje pasek menu do górnego obszaru panelu BorderPane
    // oraz etykietę do obszaru środkowego.
    rootNode.setTop(mb); 

    // Tworzy panel FlowPane, który będzie prezentował zarówno etykietę
    // response, jak i pole tekstowe.
    FlowPane fpRoot = new FlowPane(10, 10);

    // Wyrównuje kontrolki do środka.
    fpRoot.setAlignment(Pos.CENTER);

    // Używa separatora by lepiej zorganizować układ.
    Separator separator = new Separator();  
    separator.setPrefWidth(260);  

    // Dodaje do panelu etykietę i pole tekstowe.
    fpRoot.getChildren().addAll(response, separator, tf);

    // Dodaje pasek narzędzi u dołu panelu BorderPane
    rootNode.setBottom(tbDebug);

    // Dodaje panel FlowPane w środkowym obszarze panelu BorderPane.
    rootNode.setCenter(fpRoot);   

    // Wyświetla obszar roboczy i scenę.
    myStage.show();  
  }

  // Tworzy menu Plik. 
  void makeFileMenu() {
    // Tworzy menu Plik wraz z mnemoniką 
    Menu fileMenu = new Menu("_Plik"); 
    
    // Tworzy opcje menu
    MenuItem open = new MenuItem("Otwórz"); 
    MenuItem close = new MenuItem("Zamknij"); 
    MenuItem save = new MenuItem("Zapisz"); 
    MenuItem exit = new MenuItem("Zakończ"); 

    // Dodaje opcje do menu
    fileMenu.getItems().addAll(open, close, save, 
                               new SeparatorMenuItem(), exit); 

    // Dodaje akceleratory do elementów menu Plik.
    open.setAccelerator(KeyCombination.keyCombination("shortcut+O"));
    close.setAccelerator(KeyCombination.keyCombination("shortcut+M"));
    save.setAccelerator(KeyCombination.keyCombination("shortcut+Z"));
    exit.setAccelerator(KeyCombination.keyCombination("shortcut+K"));

    // Ustawia obiekt obsługujący zdarzenia akcji.
    open.setOnAction(MEHandler); 
    close.setOnAction(MEHandler); 
    save.setOnAction(MEHandler); 
    exit.setOnAction(MEHandler); 

    // Dodaje menu Plik do paska menu.
    mb.getMenus().add(fileMenu); 
  }

  // Tworzy menu Opcje.
  void makeOptionsMenu() { 
    Menu optionsMenu = new Menu("Opcje"); 

    // Tworzy podmenu Kolory.
    Menu colorsMenu = new Menu("Kolory"); 
              
    // W podmenu Kolory są używane elementy menu z polami wyboru. 
    // W ten sposób użytkownik  może wybrać więcej niż jeden kolor. 
    CheckMenuItem red = new CheckMenuItem("Czerwony"); 
    CheckMenuItem green = new CheckMenuItem("Zielony"); 
    CheckMenuItem blue = new CheckMenuItem("Niebieski"); 

    // Dodaje pola wyboru menu Kolory do podmenu,
    // a następnie podmenu Kolory do menu Opcje.
    colorsMenu.getItems().addAll(red, green, blue); 
    optionsMenu.getItems().add(colorsMenu); 

    // Zaznacza opcję z kolorem zielonym.
    green.setSelected(true); 
              
    // Tworzy podmenu Priorytet.
    Menu priorityMenu = new Menu("Priorytet"); 
             
    // W podmenu Priorytet są używane elementy menu z przyciskami opcji.
    // W ten sposób możemy pokazać aktualnie wybrany priorytet,
    // a jednocześnie mamy pewność, że w dowolnej chwili będzie wybrany
    // tylko jeden priorytet. 
    RadioMenuItem high = new RadioMenuItem("Wysoki"); 
    RadioMenuItem low = new RadioMenuItem("Niski"); 
             
    // Tworzy grupę i umieszcza w niej elementy menu z przyciskami opcji. 
    ToggleGroup tg = new ToggleGroup(); 
    high.setToggleGroup(tg); 
    low.setToggleGroup(tg); 
     
    // Zaznacza opcję z wysokim priorytetem.
    high.setSelected(true); 
     
    // Dodaje elementy menu z przyciskami opcji do podmenu Priorytet,
    // a następnie to podmenu do menu Opcje.
    priorityMenu.getItems().addAll(high, low); 
    optionsMenu.getItems().add(priorityMenu); 
             
    // Dodaje separator. 
    optionsMenu.getItems().add(new SeparatorMenuItem()); 
            
    // Tworzy opcję Resetuj. 
    MenuItem reset = new MenuItem("Resetuj"); 
    optionsMenu.getItems().add(reset); 

    // Ustawia obiekt obsługujący zdarzenia akcji.
    red.setOnAction(MEHandler); 
    green.setOnAction(MEHandler); 
    blue.setOnAction(MEHandler); 
    high.setOnAction(MEHandler); 
    low.setOnAction(MEHandler); 
    reset.setOnAction(MEHandler); 
 
    // Używa obiektu nasłuchującego ChangeListener do obsługi zmiany
    // wybranego przycisku opcji w menu.
    tg.selectedToggleProperty().addListener(new ChangeListener<Toggle>() { 
      public void changed(ObservableValue<? extends Toggle> changed, 
                         Toggle oldVal, Toggle newVal) { 
        if(newVal==null) return; 
 
        // Rzutuje newVal do RadioButton. 
        RadioMenuItem rmi = (RadioMenuItem) newVal;  
 
        // Wyświetla wybraną opcję.
        response.setText("Wybrano priorytet: " + rmi.getText()); 
      } 
    }); 
    
    // Dodaje menu Opcje do paska menu.
    mb.getMenus().add(optionsMenu);
  }

  // Tworzy menu Pomoc.
  void makeHelpMenu() {

    // Tworzy widok ImageView do wyświetlenia obarazu.
    ImageView aboutIV = new ImageView("aboutIcon.gif");

    // Tworzy menu Pomoc. 
    Menu helpMenu = new Menu("Pomoc"); 

    // Tworzy opcję O programie i dodaje ją do menu.
    MenuItem about = new MenuItem("O programie", aboutIV);   
    helpMenu.getItems().add(about); 
 
    // Ustawia obiekt obsługujący zdarzenia akcji.
    about.setOnAction(MEHandler); 

    // Dodaje menu Pomoc do paska menu. 
    mb.getMenus().add(helpMenu); 
  }

  // Tworzy menu podręczne.
  void makeContextMenu() {

    // Tworzy elementy menu podręcznego.
    MenuItem cut = new MenuItem("Wytnij");
    MenuItem copy = new MenuItem("Kopiuj");
    MenuItem paste = new MenuItem("Wklej");

    // Tworzy menu podręczne (kontekstowe) prezentujące opcje edycji.
    editMenu = new ContextMenu(cut, copy, paste);

    // Ustawia obiekt obsługujący zdarzenia akcji.
    cut.setOnAction(MEHandler);
    copy.setOnAction(MEHandler);
    paste.setOnAction(MEHandler);
  }

  // Tworzy pasek narzędzi.
  void makeToolBar() {
    // Definiuje pasek narzędzi. W pierwszej kolejności tworzone 
    // są przyciski, które zostaną na nim umieszczone. 
    Button btnSet = new Button("Ustaw punkt wstrzymania", 
                               new ImageView("setBP.gif")); 
    Button btnClear = new Button("Usuń punkt wstrzymania", 
                                 new ImageView("clearBP.gif")); 
    Button btnResume = new Button("Wznów", 
                                  new ImageView("resume.gif")); 
     
    // Wyłącz prezentowanie tekstu w przyciskach paska narzędzi. 
    btnSet.setContentDisplay(ContentDisplay.GRAPHIC_ONLY); 
    btnClear.setContentDisplay(ContentDisplay.GRAPHIC_ONLY); 
    btnResume.setContentDisplay(ContentDisplay.GRAPHIC_ONLY); 
     
    // Określa etykiety ekranowe. 
    btnSet.setTooltip(new Tooltip("Ustawia punkt wstrzymania.")); 
    btnClear.setTooltip(new Tooltip("Usuwa punkt wstrzymania.")); 
    btnResume.setTooltip(new Tooltip("Wznawia realizację programu.")); 
     
    // Tworzy pasek narzędzi. 
    tbDebug = new ToolBar(btnSet, btnClear, btnResume);

    // Tworzy obiekt nasłuchujący, obsługujący zdarzenia ActionEvent generowane przez przyciski paska narzędzi.
    EventHandler<ActionEvent> btnHandler = new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        response.setText(((Button)ae.getTarget()).getText());  
      }  
    };  
     
    // Określa obiekt nasłuchujący dla poszczególnych przycisków. 
    btnSet.setOnAction(btnHandler); 
    btnClear.setOnAction(btnHandler); 
    btnResume.setOnAction(btnHandler);
  }
}
