// Prezentacja list. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.geometry.*; 
import javafx.beans.value.*; 
import javafx.collections.*; 
 
public class ListViewDemo extends Application { 
 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);   
  } 
 
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja list"); 
 
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku odstępy pomiędzy komponentami wynoszą 10.  
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 270, 150); 
 
    // Zapisuje obiekt sceny w obszarze roboczym. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę. 
    response = new Label("Wybierz środek transportu"); 
 
    // Tworzy listę ObservableList elementów, które zostaną wyświetlone
    // w kontrolce ListView.
    ObservableList<String> transportTypes = 
      //FXCollections.observableArrayList( "Pociąg", "Samochód", "Samolot" );  
      FXCollections.observableArrayList( "Pociąg", "Samochód", "Samolot", "Rower", "Na piechotę" );  
 
    // Tworzy listę - kontrolkę ListView. 
    ListView<String> lvTransport = new ListView<String>(transportTypes); 
 
    // Określa preferowaną szerokość i wysokość listy. 
    lvTransport.setPrefSize(80, 80); 
 
    // Pobiera aktualnie używany model wyboru. 
    MultipleSelectionModel<String> lvSelModel = 
                                     lvTransport.getSelectionModel(); 
 

    // włączenie możliwości wielokrotnego wyboru
    //lvTransport.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);                                     

    // Określa obiekt nasłuchujący, który będzie obsługiwał zmianę 
    // zaznaczonego elementu listy.
    lvSelModel.selectedItemProperty().addListener( 
                                      new ChangeListener<String>() { 
      public void changed(ObservableValue<? extends String> changed, 
                          String oldVal, String newVal) { 
 
        // Wyświetla zaznaczony element listy. 
        response.setText("Wybranym środkiem transportu jest: " + newVal); 
      } 
     }); 
 
    /*
    // obsługa wielokrotnego wyboru
    lvSelModel.selectedItemProperty().addListener( 
                                      new ChangeListener<String>() { 
      public void changed(ObservableValue<? extends String> changed, 
                          String oldVal, String newVal) { 
     
        String selItems = ""; 
        ObservableList<String> selected = 
                  lvTransport.getSelectionModel().getSelectedItems(); 
     
        // Wyświetla zaznaczone elementy. 
        for(int i=0; i < selected.size(); i++) 
          selItems += "\n      " + selected.get(i); 
               
        response.setText("Wybrane środki transportu: " + selItems); 
      } 
    });
    */


    // Dodaje etykietę i listę do grafu sceny.
    rootNode.getChildren().addAll(lvTransport, response); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
