// Przykład użycia klasy JToggleButton.
import java.awt.*; 
import java.awt.event.*; 
import javax.swing.*; 
 
public class JToggleButtonDemo { 
 
  public JToggleButtonDemo() { 
 
    // przygotowuje okno JFrame
    JFrame jfrm = new JFrame("JToggleButtonDemo");
    jfrm.setLayout(new FlowLayout());
    jfrm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    jfrm.setSize(200, 100); 
 
    // tworzy etykietę
    JLabel jlab = new JLabel("Przycisk jest wyłączony");  
 
    // tworzy przycisk JToggleButton
    JToggleButton jtbn =  new JToggleButton("Włączony/wyłączony"); 
 
    // dodaje obiekt nasłuchujący zdarzeń typu ItemEvent do przycisku przełącznika
    jtbn.addItemListener(new ItemListener() { 
      public void itemStateChanged(ItemEvent ie) { 
        if(jtbn.isSelected()) 
          jlab.setText("Przycisk jest włączony.");
        else 
          jlab.setText("Przycisk jest wyłączony.");
      } 
    }); 
  
    // dodaje przycisk przełącznika i etykietę do panelu treści.
    jfrm.add(jtbn);   
    jfrm.add(jlab);  

    // wyświetla okno
    jfrm.setVisible(true);
  } 

  public static void main(String[] args) { 

    // tworzy okno w wątku obsługującym zdarzenia
    SwingUtilities.invokeLater( 
      new Runnable() { 
        public void run() { 
          new JToggleButtonDemo(); 
        } 
      } 
    ); 
  }
}
