// Prezentacja przełącznika.
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class ToggleButtonDemo extends Application { 
 
  ToggleButton tbOnOff; 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);   
  } 
 
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja przełączników"); 
 
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku odstępy pomiędzy komponentami wynoszą 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 280, 120); 
 
    // Zapisuje obiekt sceny w obszarze roboczym. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę. 
    response = new Label("Kliknij przycisk."); 
 
    // Tworzy przełącznik.
    tbOnOff = new ToggleButton("Włączony/Wyłączony"); 
 
    // Obsługa zdarzeń przełącznika.
    tbOnOff.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        if(tbOnOff.isSelected()) response.setText("Przycisk jest włączony."); 
        else response.setText("Przycisk jest wyłączony."); 
      } 
    }); 
 
    // Dodaje etykietę i przełącznik do grafu sceny. 
    rootNode.getChildren().addAll(tbOnOff, response); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
