// Prezentacja pól tekstowych - kontrolek TextField. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class TextFieldDemo extends Application { 
 
  TextField tf; 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);   
  } 
 
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja pól tekstowych"); 
 
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku odstępy pomiędzy komponentami wynoszą 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 230, 140); 
 
    // Zapisuje obiekt sceny w obszarze roboczym. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę, w której będzie wyświetlana 
    // poszukiwana fraza odczytana z pola tekstowego. 
    response = new Label("Poszukiwana fraza: "); 
 
    // Tworzy przycisk używany do pobrania frazy. 
    Button btnGetText = new Button("Pobierz poszukiwaną frazę"); 
 
    // Tworzy pole tekstowe. 
    tf = new TextField(); 
 
    // Określa komunikat początkowy. 
    tf.setPromptText("Wpisz poszukiwaną frazę"); 
 
    // Ustawia preferowaną szerokość pola. 
    tf.setPrefColumnCount(15); 
 
    // Obsługa zdarzeń ActionEvent pola tekstowego. Zdarzenia te
    // są generowane w wyniku naciśnięcia klawisza Enter podczas
    // edycji zawartości pola tekstowego. W tym programie po 
    // kliknięciu Enter zawartość pola tekstowego zostanie 
    // pobrana i wyświetlona.
    tf.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Poszukiwana fraza: " + tf.getText()); 
      } 
    }); 
 
    // Pobranie tekstu z pola w wyniku kliknięcia przycisku.
    btnGetText.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Poszukiwana fraza: " + tf.getText()); 
      } 
    }); 
 
    // Tworzy separator, by poprawić wygląd układu. 
    Separator separator = new Separator(); 
    separator.setPrefWidth(180); 
 
    // Dodaje wszystkie kontrolki do grafu sceny. 
    rootNode.getChildren().addAll(tf, btnGetText, separator, response); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
