// Prosty przykład stosowania przycisków opcji.
// 
// Ten program odpowiada na zdarzenia ActionEvent
// generowane przez wybierane przyciski opcji. Program
// pokazuje także, jak można programowo generować
// zdarzenia.
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class RadioButtonDemo extends Application { 
 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);   
  } 
 
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Demonstrate Radio Buttons"); 
 
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku odstępy pomiędzy komponentami wynoszą 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 290, 120); 
 
    // Zapisuje obiekt sceny w obszarze roboczym. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę prezentującą aktualnie wybraną opcję.
    response = new Label(""); 
 
    // Tworzy przyciski opcji. 
    RadioButton rbTrain = new RadioButton("Pociąg"); 
    RadioButton rbCar = new RadioButton("Samochód"); 
    RadioButton rbPlane = new RadioButton("Samolot"); 
 
    // Tworzy grupę przycisków opcji. 
    ToggleGroup tg = new ToggleGroup(); 
 
    // Dodaje poszczególne przyciski do grupy. 
    rbTrain.setToggleGroup(tg); 
    rbCar.setToggleGroup(tg); 
    rbPlane.setToggleGroup(tg); 
 
    // Obiekt nasłuchujący obsługujący zdarzenia generowane przez przyciski opcji. 
    rbTrain.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Wybranym środkiem transportu jest pociąg."); 
      } 
    }); 
 
    rbCar.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Wybranym środkiem transportu jest samochód."); 
      } 
    }); 
 
    rbPlane.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Wybranym środkiem transportu jest samolot."); 
      } 
    }); 
 
    // Generuje zdarzenie dla pierwszego przycisku opcji. 
    // Powoduje to zaznaczenie przycisku i wygenerowanie
    // zdarzenia ActionEvent.
    rbTrain.fire(); 
 
    // Dodaje etykietę i przyciski do grafu sceny.
    rootNode.getChildren().addAll(rbTrain, rbCar, rbPlane, response); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
