// Prezentacja zdarzeń i przycisków JavaFX. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class JavaFXEventDemo extends Application { 
 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX.
    launch(args);   
  } 
 
  // Przesłonięta metoda start().
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja przycisków i zdarzeń JavaFX"); 
 
    // Tworzy panel FlowPane, który stanie się węzłem korzenia. 
    // W tym przypadku pionowe i poziome odstępy pomiędzy 
    // komponentami będą miały wielkość 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 300, 100); 
 
    // Zapisuje obiekt sceny w obszarze roboczym.
    myStage.setScene(myScene); 
 
    // Tworzy etykietę. 
    response = new Label("Kliknij przycisk"); 
 
    // Tworzy dwa przyciski. 
    Button btnAlpha = new Button("Alfa"); 
    Button btnBeta = new Button("Beta"); 
 
    // Obsługa zdarzeń ActionEvent przycisku Alfa. 
    btnAlpha.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Kliknięto przycisk Alfa."); 
      } 
    }); 
 
    // Obsługa zdarzeń ActionEvent przycisku Beta. 
    btnBeta.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Kliknięto przycisk Beta."); 
      } 
    }); 
 
    // Dodaje etykietę i przyciski do grafu sceny.
    rootNode.getChildren().addAll(btnAlpha, btnBeta, response); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
