// Program używa zsynchronizowanego bloku.
class Callme {
  void call(String msg) {
    System.out.print("[" + msg);
    try {
      Thread.sleep(1000);
    } catch (InterruptedException e) {
      System.out.println("Przerwano");
    }
    System.out.println("]");
  }
}

class Caller implements Runnable {
  String msg;
  Callme target;
  Thread t;

  public Caller(Callme targ, String s) {
    target = targ;
    msg = s;
    t = new Thread(this);
  }

  // synchronizacja wywołań metody call()
  public void run() {
    synchronized(target) { // synchronizowany blok
      target.call(msg);
    }
  }
}

class Synch1 {
  public static void main(String args[]) {
    Callme target = new Callme();
    Caller ob1 = new Caller(target, "Witaj");
    Caller ob2 = new Caller(target, "Zsynchronizowany");
    Caller ob3 = new Caller(target, "Świecie");

    // uruchomienie wątków
    ob1.t.start();
    ob2.t.start();
    ob3.t.start();

    // czeka na zakończenie wątków
    try {
      ob1.t.join();
      ob2.t.join();
      ob3.t.join();
    } catch(InterruptedException e) {
      System.out.println("Przerwano");
    }
  }
}
