package rozdzial32;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.embed.swing.SwingNode;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

import javax.swing.*;

public class Listing32_03 extends Application {
    public static void main(String[] args) {

        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        final SwingNode swingNode = new SwingNode();
        SwingUtilities.invokeLater(() -> {
            CardPanel cp = new CardPanel();
            Thread t = new Thread(cp);
            t.start();
            swingNode.setContent(cp);
        });
        StackPane pane = new StackPane();
        pane.getChildren().add(swingNode);
        Scene scene = new Scene(pane, 800, 800);
        stage.setScene(scene);
        stage.setTitle("Animacja karty");
        stage.setOnCloseRequest(e -> {
            ((CardPanel)swingNode.getContent()).stop();
            Platform.exit();
        });
        stage.setTitle("Swing w JavaFX");
        stage.show();
    }
}
