package rozdzial14;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Listing14_20 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            Circle circle = new Circle();
            circle.setCenterX(150);
            circle.setCenterY(150);
            circle.setFill(Color.DEEPSKYBLUE);
            root.getChildren().add(circle);
            Scene scene = new Scene(root, 300, 300);
            stage.setScene(scene);
            stage.show();
            EventHandler<ActionEvent> onFinished = t -> System.out.println("Zrobiłam to pierwszy i ostatni raz!");
            KeyValue kv1 = new KeyValue(circle.radiusProperty(), 10,
                    Interpolator.LINEAR);
            KeyFrame kf1 = new KeyFrame(Duration.millis(0), kv1);
            //-
            KeyValue kv2 = new KeyValue(circle.radiusProperty(), 80,
                    Interpolator.LINEAR);
            KeyFrame kf2 = new KeyFrame(Duration.millis(1500), kv2);
            //-
            KeyValue kv3 = new KeyValue(circle.radiusProperty(), 10,
                    Interpolator.LINEAR);
            KeyFrame kf3 = new KeyFrame(Duration.millis(3000), kv3);
            KeyValue kv4 = new KeyValue(circle.radiusProperty(), 0,
                    Interpolator.LINEAR);
            KeyFrame kf4 = new KeyFrame(Duration.millis(4500), kv4);
            //-
            Timeline timeline = new Timeline();
            timeline.setOnFinished(onFinished);
            timeline.getKeyFrames().addAll(kf1, kf2, kf3, kf4);
            timeline.setCycleCount(1);
            timeline.setRate(-1.0);
            timeline.jumpTo("end");
            timeline.play();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
