package rozdzial31;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

import java.net.URL;

public class Listing31_04 extends Application {

    private Alert alert;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            WebView wv = new WebView();
            WebEngine we = wv.getEngine();
            URL url = this.getClass().getClassLoader().getResource("resources/html/alert.html");
            if (url != null) {
                we.load(url.toExternalForm());
            }
            we.setOnAlert(event -> {
                alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("Komunikat z bieżącej strony:");
                alert.setHeaderText(event.getData());
                alert.initOwner(stage);
                alert.showAndWait();
            });
            root.getChildren().add(wv);
            Scene scene = new Scene(root, 560, 360);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
