package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.SepiaTone;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

import java.io.File;
import java.io.FileInputStream;

public class Listing13_10 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Image image = new Image(
                    new FileInputStream(new File("src/rozdzial13/pies.jpg")));
            ImageView imageView = new ImageView(image);
            imageView.setFitWidth(300);
            imageView.setFitHeight(285);
            imageView.setPreserveRatio(true);
            imageView.setLayoutX(230);
            imageView.setLayoutY(10);
            Pane root = new Pane();
            //efekt
            SepiaTone ds = new SepiaTone();
            imageView.setEffect(ds);
            //slider 3
            Slider cslider = new Slider(0.0, 1.0, 1.0);
            cslider.setLayoutX(80);
            cslider.setLayoutY(100);
            cslider.setMajorTickUnit(0.1);
            cslider.setShowTickLabels(true);
            cslider.setShowTickMarks(true);
            ds.levelProperty().bind(cslider.valueProperty());
            Label slabel = new Label("level: ");
            slabel.setLabelFor(cslider);
            slabel.setLayoutX(20);
            slabel.setLayoutY(100);
            //
            root.getChildren().addAll(cslider, slabel, imageView);
            Scene scene = new Scene(root, 560, 305);
            scene.setFill(Color.WHITE);
            stage.setScene(scene);
            stage.setTitle("Glow");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
