package rozdzial30;

import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.scene.Scene;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class AriaPreloader1 extends Preloader {
    private Stage stage;
    private ProgressBar bar;

    @Override
    public void init() {
        //na razie pusta
    }

    @Override
    public void start(Stage stage) {
        this.stage = stage;
        try {
            bar = new ProgressBar();
            bar.setProgress(0);
            bar.setPrefWidth(200);
            bar.setPrefHeight(30);
            StackPane root = new StackPane();
            root.getChildren().add(bar);
            Scene scene = new Scene(root, 400, 224);
            stage.setScene(scene);
            stage.setTitle("AriaPreloader1");
            stage.setOnCloseRequest(e -> Platform.exit());
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void handleProgressNotification(ProgressNotification progressNotification) {
        super.handleProgressNotification(progressNotification);
    }

    @Override
    public void handleStateChangeNotification(StateChangeNotification stateChangeNotification) {
        if (stateChangeNotification.getType() == StateChangeNotification.Type.BEFORE_START) {
            stage.hide();
        }
    }

    @Override
    public void handleApplicationNotification(PreloaderNotification preloaderNotification) {
        if (preloaderNotification instanceof ProgressNotification) {
            double v = ((ProgressNotification) preloaderNotification).getProgress();
            bar.setProgress(v);
        }
    }

    @Override
    public boolean handleErrorNotification(ErrorNotification errorNotification) {
        return super.handleErrorNotification(errorNotification);
    }
}
