package rozdzial22;

import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javafx.util.Callback;

public class Listing22_14 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @SuppressWarnings("unchecked")
    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            ObservableList<Naklady> olist = Naklady.wstawDane();
            TableView<Naklady> tv1 = new TableView<>();
            tv1.setItems(olist);
            TableColumn<Naklady, Integer> rokCol = new TableColumn<>("Rok");
            rokCol.setCellValueFactory(
                    new PropertyValueFactory<>("rok"));
            rokCol.setCellFactory(
                    new Callback<>() {
                        @Override
                        public TableCell<Naklady, Integer> call(
                                TableColumn<Naklady, Integer> param) {
                            return new TableCell<>() {
                                @Override
                                public void updateItem(Integer i,
                                                       boolean empty) {
                                    super.updateItem(i, empty);
                                    this.setGraphic(null);
                                    this.setText(null);
                                    if (!empty) {
                                        Font f = this.getFont();
                                        Font f1 = Font.font(f.getFamily(),
                                                FontWeight.BOLD, f.getSize());
                                        setFont(f1);
                                        setText(i.toString());
                                    }
                                }
                            };
                        }
                    });
            TableColumn<Naklady, Double> oswiataCol = new TableColumn<>(
                    "Oświata");
            oswiataCol.setCellValueFactory(
                    new PropertyValueFactory<>("oswiata"));
            oswiataCol.setCellFactory(
                    new Callback<>() {
                        @Override
                        public TableCell<Naklady, Double> call(
                                TableColumn<Naklady, Double> param) {
                            return new TableCell<>() {
                                @Override
                                public void updateItem(Double i,
                                                       boolean empty) {
                                    super.updateItem(i, empty);
                                    this.setGraphic(null);
                                    this.setText(null);
                                    this.setTextFill(Color.BLACK);
                                    if (!empty) {
                                        double value = i;
                                        if (value > 400) {
                                            setTextFill(Color.GREEN);
                                        }
                                        setText(i.toString());
                                    }
                                }
                            };
                        }
                    });
            TableColumn<Naklady, Double> kulturaCol = new TableColumn<>(
                    "Kultura");
            kulturaCol.setCellValueFactory(
                    new PropertyValueFactory<>("kultura"));
            TableColumn<Naklady, Double> zdrowieCol = new TableColumn<>(
                    "Zdrowie");
            zdrowieCol.setCellValueFactory(
                    new PropertyValueFactory<>("zdrowie"));
            tv1.getColumns().setAll(rokCol, oswiataCol, kulturaCol, zdrowieCol);
            root.getChildren().add(tv1);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
