package rozdzial35;

import javafx.application.Application;
import javafx.print.PrinterJob;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Listing35_02 extends Application {
    private Canvas canvas;
    private GraphicsContext gc;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            canvas = new Canvas(400, 400);
            gc = canvas.getGraphicsContext2D();
            gc.setFill(Color.BLACK);
            gc.setStroke(Color.BLACK);
            drawChessboard(40, 40, 300);
            Button but = new Button("Drukuj");
            but.setOnAction(event -> {
                PrinterJob pj = PrinterJob.createPrinterJob();
                if (pj == null) {
                    return;
                }
                boolean proc = pj.showPageSetupDialog(stage);
                if (proc) {
                    boolean printed = pj.printPage(canvas);
                    if (printed) {
                        pj.endJob();
                    }
                }
            });
            root.getChildren().addAll(canvas, but);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.setTitle("Szachownica");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawChessboard(double x, double y, double size) {
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                if ((i + j) % 2 != 0) {
                    gc.fillRect(x, y, size / 8.0, size / 8.0);
                }
                gc.translate(size / 8.0, 0);
            }
            gc.translate(-size, size / 8.0);
        }
        gc.strokeRect(x, y - size, size, size);
    }
}
