package rozdzial31;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker.State;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.stage.Stage;
import netscape.javascript.JSObject;

import java.net.URL;

public class Listing31_12 extends Application {

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Browser root = new Browser(stage);
            WebEngine we = root.getWe();
            URL url = this.getClass().getClassLoader()
                    .getResource("resources/html/fibo.html");
            if (url != null) {
                we.load(url.toExternalForm());
            }
            we.getLoadWorker().stateProperty()
                .addListener(new ChangeListener<State>() {
                    @Override
                    public void changed(ObservableValue<? extends State> observable, State oldValue, State newValue) {
                        if (newValue == State.SUCCEEDED) {
                            JSObject jsWindow = (JSObject) we
                                    .executeScript("window");
                            jsWindow.setMember("fibo",
                                    new Fibo());
                        }
                    }
                });
            Scene scene = new Scene(root, 560, 560);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
