package rozdzial30;

import javafx.application.Application;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class Listing30_06 extends Application {

    public static void main(String[] args) {

        Application.launch(args);
    }

    @Override
    public void init(){}

    @Override
    public void start(Stage stage) {
        try {
            HostServices hs = getHostServices();
            String codeBase = hs.getCodeBase();
            System.out.println("codeBase: " + codeBase);
            String docBase = hs.getDocumentBase();
            System.out.println("docBase: " + docBase);
            String smok = hs.resolveURI(docBase,
                    "src/rozdzial30/samsmok64.png");
            System.out.println(smok);
            Image image = new Image(smok);
            ImageView iv = new ImageView(image);
            StackPane root = new StackPane();
            root.getChildren().add(iv);
            Scene scene = new Scene(root, 300, 200);
            stage.setScene(scene);
            stage.setTitle(this.getClass().getName());
            stage.setOnCloseRequest(e -> Platform.exit());
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop(){}
}
