package rozdzial25;

import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Listing25_10 extends Application {
    private GraphicsContext gc;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Group root = new Group();
            Canvas canvas = new Canvas(400, 400);
            gc = canvas.getGraphicsContext2D();
            gc.setFill(Color.BLACK);
            gc.setStroke(Color.BLACK);
            drawChessboard(40, 40, 300);
            root.getChildren().add(canvas);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawChessboard(double x, double y, double size) {
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                if ((i + j) % 2 != 0) {
                    gc.fillRect(x, y, size / 8.0, size / 8.0);
                }
                gc.translate(size / 8.0, 0);
            }
            gc.translate(-size, size / 8.0);
        }
        gc.strokeRect(x, y - size, size, size);
    }
}
