package rozdzial21;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Listing21_01 {
    public static void main(String[] args) {
        ArrayList<Nick> al = new ArrayList<>();
        Optional<Nick> optNick1 = Optional.empty();
        boolean b1 = optNick1.isPresent();
        System.out.println("b1: " + b1);
        Nick n1a = optNick1.orElse(new Nick("Unknown"));
        System.out.println("n1a: " + n1a);
        Supplier<Nick> sup1 = () -> new Nick("Nieznany");
        Nick n1b = optNick1.orElseGet(sup1);
        System.out.println("n1b: " + n1b);
        //-
        Nick nick2 = new Nick("Jack");
        Optional<Nick> optNick2 = Optional.of(nick2);
        boolean b2 = optNick2.isPresent();
        System.out.println("b2: " + b2);
        if (b2) {
            System.out.println(optNick2.get());
        }
        Nick n2a = optNick2.orElse(new Nick("Unknown"));
        System.out.println("n2a: " + n2a);
        Nick n2b = optNick2.orElseGet(sup1);
        System.out.println("n2b: " + n2b);
        Consumer<Nick> print = s -> {
            System.out.println(s);
        };
        Consumer<Nick> add = s -> {
            al.add(s);
        };
        optNick2.ifPresent(print.andThen(add));
        Predicate<Nick> p = x -> x.getStr().startsWith("J");
        Optional<Nick> f = optNick2.filter(p);
        System.out.println(f.isPresent() ? f.get() : "");
        Optional<String> n2 = optNick2.map(Nick::getStr);
        System.out.println(n2.isPresent() ? n2.get() : "");
        //-
        Nick nick3 = null;
        Optional<Nick> optNick3 = Optional.ofNullable(nick3);
        boolean b3 = optNick3.isPresent();
        System.out.println("b3: " + b3);
        Nick n3a = optNick3.orElse(new Nick("Unknown"));
        System.out.println("n3a: " + n3a);
        Nick n3b = optNick3.orElseGet(sup1);
        System.out.println("n3b: " + n3b);
        //-
        Optional<Optional<String>> notFlat = optNick2
                .map(new Function<Nick, Optional<String>>() {
                    @Override
                    public Optional<String> apply(Nick nick) {
                        return nick == null
                                ? Optional.empty()
                                : Optional.of(nick.getStr().toUpperCase());
                    }
                });
        System.out.println(notFlat);
        Optional<String> flat = optNick2
                .flatMap(new Function<Nick, Optional<String>>() {
                    @Override
                    public Optional<String> apply(Nick nick) {
                        return nick == null
                                ? Optional.empty()
                                : Optional.of(nick.getStr().toUpperCase());
                    }
                });
        System.out.println(flat);
    }
}