package rozdzial18;

import javafx.application.Application;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

import java.util.HashMap;
import java.util.Map;

public class Listing18_27 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            Label label = new Label("Wybierz najładniejszą forme imienia: ");
            Map<String, ObservableValue<Boolean>> mapa = new HashMap<>();
            mapa.put("Urszula", new SimpleBooleanProperty(false));
            mapa.put("Ula", new SimpleBooleanProperty(false));
            mapa.put("Ulka", new SimpleBooleanProperty(false));
            mapa.put("Ulessa", new SimpleBooleanProperty(false));
            mapa.put("Uleńka", new SimpleBooleanProperty(false));
            ListView<String> lv1 = new ListView<>();
            lv1.setEditable(true);
            lv1.getItems().addAll(mapa.keySet());
            Callback<String, ObservableValue<Boolean>> cellFactory = mapa::get;
            lv1.setCellFactory(CheckBoxListCell.forListView(cellFactory));
            root.getChildren().addAll(label, lv1);
            Scene scene = new Scene(root, 200, 200);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
